<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->string('product_code')->unique();
            $table->string('name')->nullable();
            $table->text('description')->nullable();
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('sub_category_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->double('purchase_price')->nullable()->default(0);
            $table->unsignedBigInteger('purchase_discount_type_id')->nullable();
            $table->unsignedBigInteger('purchase_tax_id')->nullable();
            $table->double('sale_price')->nullable()->default(0);
            $table->unsignedBigInteger('sale_discount_type_id')->nullable();
            $table->unsignedBigInteger('sale_tax_id')->nullable();
            $table->string('product_alice')->nullable();
            $table->boolean('imei_suport')->default(0);
            $table->string('product_sku')->nullable();
            $table->double('alert_qty')->default(0)->nullable();
            $table->integer('expire_in')->nullable();
            $table->date('expire_date')->nullable();
            $table->string('rack')->nullable();
            $table->string('row')->nullable();
            $table->string('possition')->nullable();
            $table->string('weight')->nullable();
            $table->string('dimensions')->nullable();
            $table->decimal('opening_stock', 10, 2)->default(0)->nullable();
            $table->unsignedBigInteger('opening_by')->nullable();
            $table->date('opening_date')->nullable();
            $table->string('image')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->integer('warranty')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
