<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('salereturn_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_return_id');
            $table->unsignedBigInteger('product_id')->nullable();
            $table->double('unit_price')->default(0);
            $table->double('qty')->default(0);
            $table->double('amount')->default(0);
            $table->double('vat_percent')->default(0)->nullable();
            $table->double('vat_amount')->default(0);
            $table->double('discount')->default(0)->nullable();
            $table->double('discount_percent')->default(0)->nullable();
            $table->double('discount_amount')->default(0);
            $table->double('nettotal')->default(0);
            $table->text('product_note')->nullable();
            $table->enum('return_status', ['draft', 'return'])->default('draft');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salereturn_details');
    }
};
