<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('company_name')->nullable();
            $table->string('owner_name')->nullable();
            $table->string('gst_number')->nullable();
            $table->string('igt_number')->nullable();
            $table->string('vat_Number')->nullable();
            $table->string('license_number')->nullable();
            $table->string('tax_No')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->unsignedBigInteger('state_id')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->unsignedBigInteger('currency_id')->nullable();
            $table->unsignedBigInteger('zone_id')->nullable();
            $table->string('date_format')->nullable();
            $table->string('address')->nullable();
            $table->string('mobile')->nullable();
            $table->string('alternative_mobile')->nullable();
            $table->string('telephone')->nullable();
            $table->string('email')->nullable();
            $table->string('attachment_url')->nullable();
            $table->string('website')->nullable();
            $table->string('document')->nullable();
            $table->string('logo')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
