<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchasepayments', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_no')->nullable();
            $table->timestamp('payment_date');
            $table->unsignedBigInteger('company_branch_id')->nullable();
            $table->unsignedBigInteger('purchase_id')->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('transection_id')->nullable();
            $table->string('payment_method')->nullable();
            $table->enum('type',['purchase','return'])->default('purchase');
            $table->double('amount')->default('0');
            $table->string('note')->nullable();
            $table->boolean('is_primary')->default(0);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchasepayments');
    }
};
