<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_informaions', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('operation_id')->nullable();
            $table->enum('type',['purchase','purchase return','sale','sale return','supplier payment','other_payment'])->default('purchase');
            $table->unsignedBigInteger('payment_method_field_id')->nullable();
            $table->string('information')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_informaions');
    }
};
