<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_discounts', function (Blueprint $table) {
            $table->id();
            $table->string('discount_code')->nullable();
            $table->string('name')->nullable();
            $table->string('description')->nullable();
            $table->enum('dicount_type', ['normal', 'offer','buy_to_get'])->default('normal');
            $table->enum('amount_type', ['parcantage', 'normal'])->default('normal');
            $table->enum('operation_type', ['purchase', 'sale'])->default('sale');
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            $table->double('value')->nullable();
            $table->enum('status', ['active', 'inactive',])->default('active');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_discounts');
    }
};
