<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('salary_sheet_id');
            $table->unsignedBigInteger('employee_id');
            $table->string('month')->nullable();
            $table->integer('year');
            $table->longText('payment')->nullable()->nullable();
            $table->decimal('total_payment', 10, 2)->nullable();
            $table->longText('deduction')->nullable();
            $table->decimal('total_deduction', 10, 2)->nullable();
            $table->decimal('total_salary', 10, 2)->nullable();
            $table->decimal('total_advance', 10, 2)->nullable();
            $table->decimal('adjustment', 10, 2)->nullable();
            $table->decimal('net_salary', 10, 2)->nullable();
            $table->enum('payment_status',['pending','partials','paid','cancel'])->default('pending');
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payrolls');
    }
};
