<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->date('date');
            $table->unsignedBigInteger('expense_type_id');
            $table->unsignedBigInteger('account_id');
            $table->unsignedBigInteger('transection_id')->nullable();
            $table->string('vouche_no')->nullable();
            $table->double('amount')->default(0);
            $table->text('remark')->nullable();
            $table->string('payment_by')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
