<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_registers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // Sales Representative
            $table->decimal('opening_amount', 10, 2)->default(0); // Initial Cash
            $table->decimal('closing_amount', 10, 2)->nullable(); // Closing Cash
            $table->decimal('total_sales', 10, 2)->default(0);
            $table->decimal('total_sale_return', 10, 2)->default(0);
            $table->enum('status', ['open', 'closed'])->default('open');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_registers');
    }
};
