<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('holddetails', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hold_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->double('unit_price')->default(0);
            $table->double('qty')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('holddetails');
    }
};
