<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_mapping_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('account_mapping_id')->nullable();
            $table->unsignedBigInteger('ladger_account_id')->nullable();
            $table->enum('account_type', ['debit', 'credit'])->default('debit');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_mapping_details');
    }
};
