<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quatation_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('quatation_id');
            $table->string('product_name');
            $table->string('product_note')->nullable();
            $table->integer('qty');
            $table->decimal('unit_price', 10, 2);
            $table->decimal('amount', 12, 2);
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quatation_details');
    }
};
