<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quatation_sales', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_no')->nullable();
            $table->string('reference_no')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->unsignedBigInteger('company_branch_id')->nullable();
            $table->timestamp('sale_date')->nullable();
            $table->date('due_date')->nullable();
            $table->double('amount')->default(0);
            $table->double('discount_parcentage')->default(0);
            $table->double('total_discount')->default(0);
            $table->unsignedBigInteger('tax_id')->nullable();
            $table->double('vat_parcantage')->default(0);
            $table->double('total_vat')->default(0);
            $table->double('shiping_charge')->default(0);
            $table->double('total_amount')->default(0);
            $table->enum('gross_discount_type', ['normal', 'parcantage'])->nullable();
            $table->double('gross_discount_value')->nullable();
            $table->double('gross_discount_amount')->nullable();
            $table->double('nettotal')->nullable();
            $table->string('customer_note')->nullable();
            $table->string('private_note')->nullable();
            $table->string('custom_note')->nullable();
            $table->timestamp('delivery_date')->nullable();
            $table->string('delivery_note')->nullable();
            $table->enum('delivery_status', ['recieved', 'pending'])->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quatation_sales');
    }
};
