<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('attandance_devices', function (Blueprint $table) {
            $table->id();
            $table->string('device_name');
            $table->string('zone_name')->nullable();
            $table->string('device_type')->nullable();
            $table->string('device')->nullable();
            $table->string('device_category')->nullable();
            $table->string('punch_type')->nullable();
            $table->string('location_id')->nullable();
            $table->boolean('is_enable')->default(1);

            $table->string('ip_address')->nullable();
            $table->integer('port_number')->nullable();
            $table->tinyInteger('import_schedule')->default(0);
            $table->integer('clear_log_count')->default(10000);
            $table->boolean('is_connected')->default(1);
            $table->boolean('use_alphanumaric_id')->default(1);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('attandance_devices');
    }
};
