<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('claim_statuses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('claim_id')->nullable();
            $table->enum('status', ['sending', 'recieved', 'cancel', 'customer recieved'])->default('sending');
            $table->date('status_date')->nullable();
            $table->text('remark')->nullable();
            $table->double('charge')->nullable();
            $table->double('vat')->nullable();
            $table->double('total')->nullable();
            $table->double('tax')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('claim_statuses');
    }
};
