<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('barcode_configs', function (Blueprint $table) {
            $table->id();

            // Basic barcode size
            $table->float('width')->nullable();  // in mm or inches
            $table->float('height')->nullable();
            // Barcode type (e.g., code128, qrcode, etc.)
            $table->string('barcode_type')->nullable();
            // Page type: 'single', 'a4'
            $table->enum('page_type', ['single', 'a4'])->default('a4');
            // If using A4, how many barcodes per row
            $table->unsignedInteger('barcodes_per_row')->nullable();
            // How many rows per page for A4
            $table->unsignedInteger('rows_per_page')->nullable();
            // Gap between barcodes (horizontal and vertical spacing in mm or px)
            $table->float('gap_horizontal')->nullable();
            $table->float('gap_vertical')->nullable();
            // Margins (optional)
            $table->float('margin_top')->nullable();
            $table->float('margin_bottom')->nullable();
            $table->float('margin_left')->nullable();
            $table->float('margin_right')->nullable();

            $table->boolean('company_show')->default(0);
            $table->boolean('price_show')->default(0);
            $table->boolean('product_name_show')->default(0);
            $table->boolean('code_show')->default(0);
            $table->boolean('vat_include_show')->default(0);
            $table->enum('price_vat_include_type', ['inc', 'exc']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('barcode_configs');
    }
};
