<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('account_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->unsignedBigInteger('operation_id')->nullable();
            $table->string('voucher_no')->nullable();
            $table->string('trn_no')->nullable();
            $table->string('date')->nullable();
            $table->enum('account_operation', ['recieved', 'payment'])->default('recieved');
            $table->enum('type', ['puchase', 'purchase return', 'sale', 'sale return', 'expense', 'refund', 'transfer'])->default('puchase');
            $table->enum('account_type', ['credit', 'debit'])->debitt('credit');
            $table->double('amount')->default(0);
            $table->string('remark')->nullable();
            $table->string('recieved_by')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('btanch_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
