<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employeements', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id')->nullable();
            $table->string('name');
            $table->string('gender')->nullable();
            $table->unsignedBigInteger('designation_id');
            $table->unsignedBigInteger('department_id');
            $table->decimal('gross_salary',10,2)->nullable()->default(0);
            $table->string('mobile')->nullable();
            $table->string('email')->nullable();
            $table->date('joining_date')->nullable();
            $table->date('resign_date')->nullable();
            $table->date('last_working_date')->nullable();
            $table->string('present_address')->nullable();
            $table->string('nid_no')->nullable();
            $table->string('nid')->nullable();
            $table->string('profile_image')->nullable();
            $table->string('passport_no')->nullable();
            $table->string('passport')->nullable();
            $table->date('dob')->nullable();
            $table->string('religion')->nullable();
            $table->string('blood_group')->nullable();
            $table->enum('status',['Active','Resigned'])->default('Resigned');
            $table->unsignedBigInteger('salary_type_id')->nullable();
            $table->unsignedBigInteger('outlet_id')->nullable();
            $table->unsignedBigInteger('counter_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employeements');
    }
};
