<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('salary_type_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('salary_type_id');
            $table->string('head_name');
            $table->unsignedBigInteger('head_id')->nullable();
            $table->decimal('amount', 10, 2);
            $table->decimal('parcentage', 10, 2);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salary_type_details');
    }
};
