<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_heads', function (Blueprint $table) {
            $table->id();
            $table->string('pay_code')->unique();
            $table->enum('type',['local'])->default('local');
            $table->enum('operation_type',['pay','deduction'])->default('pay');
            $table->enum('header_type',['general','provident','medical','tax_deduction'])->default('general');
            $table->string('head_name');
            $table->boolean('is_default')->default(1);
            $table->tinyInteger('order_head')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_heads');
    }
};
