<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ladgeraccounts', function (Blueprint $table) {
            $table->id();
            $table->string('account_type');
            $table->string('account_code')->nullable();
            $table->string('name');
            $table->enum('account', ['debit', 'credit'])->default('debit');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->unsignedBigInteger('company_branch_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->decimal('account_opening', 50, 2)->nullable()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ladgeraccounts');
    }
};
