<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accountjounals', function (Blueprint $table) {
            $table->id();
            $table->string('serial_no')->nullable();
            $table->date('date');
            $table->string('month');
            $table->integer('year');
            $table->string('perticulars')->nullable();
            $table->enum('status', ['active', 'draft', 'pending'])->nullable();
            $table->string('type')->nullable();
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('note')->nullable();
            $table->unsignedBigInteger('company_branch_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accountjounals');
    }
};
