<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('payment_type_id')->nullable();
            $table->unsignedBigInteger('bank_account_id');
            $table->date('date')->nullable();
            $table->string('month')->nullable();
            $table->string('year')->nullable();
            $table->string('remark')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->enum('type', ['opening', 'running'])->default('running');
            $table->enum('journal_status', ['active', 'inactive'])->default('inactive');
            $table->unsignedBigInteger('journal_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
